@php
    use Carbon\Carbon;
@endphp

@extends('layouts.pdf.index')

{{-- @section('content-download') --}}
<div class="noprint print-download-buttons">
    @include('layouts.pdf.print-button')
    <button type="button" class="btn-hide-header" style="padding: 10px" onclick="hideIdCardBackSide()">
        {{ __('Show Front Side') }}
    </button>
    <button type="button" class="btn-hide-header" style="padding: 10px" onclick="showIdCardBackSide()">
        {{ __('Show Back Side') }}
    </button>
</div>
<div style="clear: both;"></div>
{{-- @endsection --}}

@section('content')
    <style>
        .fw700 {
            font-weight: 700
        }

        * {
            padding: 0%;
            margin: 0%
        }

        .text-center {
            text-align: center
        }

        .d-flex1 {
            display: flex;
            justify-content: flex-start;
            flex-wrap: wrap;
            gap: 60px;


        }

        .form-view {
            /* height: 100%; */
            width: 750px;
        }

        .id-card-back-footer li {
            text-align: center
        }
    </style>
    <div class="">
        @foreach ($students as $key => $student)
            <div style="float:left; margin: 15px 20px 35px 20px; height: 300px; width: 200px; background: #6FB9D4;border-radius:7px ; "
                class="show-id-card-front-side">
                <div
                    style="display: flex;flex-direction: column;justify-content: space-between;height: 100%;box-sizing: border-box;">
                    <div id="id_card">
                        <div class=""style="padding: 7.5px 5px;">
                            <table style="width: 100%;">
                                <tr>
                                    <td style="width: 20%;">
                                        <img src="{{ get_logo() }}" alt="" style="height: 100%; width: 100%;">
                                    </td>
                                    <td style="width: 80%;">
                                        <p class="fw700 text-center" style="font-size:16px; ">
                                            {{ get_option('school_name') }}
                                        </p>
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <div class="mt-1">
                            <p class="text-center fw700" style="background: #D2DE7A; padding: 3.5px; font-size: 17px;">
                                {{ _lang('Student ID Card') }}
                            </p>
                        </div>
                        <div class="image" style="text-align: center; margin-top: 7px;">
                            <img src="{{ asset('storage/users/' . $student->user->image) }}" alt=""
                                style="height: 68px;">
                        </div>
                        <div class="text-center" style="margin-top: 5px;">
                            <p class="fw700" style="height: 37px;">
                                <span
                                    style="text-transform: uppercase;font-size: 12px; word-break: break-word; padding: 0 5px;">{{ $student->first_name . ' ' . $student->last_name }}</span>
                            </p>
                            <p class="fw700">
                                <span class="lbl" style="font-size: 13px;">{{ _lang('Roll No') }} :</span>
                                <span style="font-size: 13px;">{{ $student->roll }}</span>
                            </p>
                            <p class="fw700">
                                <span class="lbl" style="font-size: 13px;">{{ _lang('Valid') }} :</span>
                                <span style="font-size: 13px;">{{ Carbon::parse($validity_date)->format('d M Y') }}</span>
                            </p>
                        </div>
                    </div>
                    <div class="d-flex" style="padding: 10px;">
                        <span style="background: #fff">
                            {{-- @php
                                $barcodeImage = null;

                                if (
                                    isset($student->studentLibrary->library_id) &&
                                    $student->studentLibrary->library_id
                                ) {
                                    $text = $student->studentLibrary->library_id;
                                    $barcode = new Picqer\Barcode\BarcodeGeneratorPNG();
                                    $barcodeImage = $barcode->getBarcode($text, $barcode::TYPE_CODE_128);
                                }
                            @endphp --}}
                            {{-- @if ($barcodeImage)
                                <img src="data:image/png;base64,{{ base64_encode($barcodeImage) }}" alt=""
                                    style="height: 15px; width: 60px; display: block; margin: 0 auto;">
                                <!-- Display text under the barcode -->
                                <p style="text-align: center; font-size:12px;padding:0%">{{ $text }}</p>
                            @endif --}}

                            {!! QrCode::size(50)->generate($student->studentSession?->qr_code) !!}
                        </span>

                        <span>
                            @if ($principalSignature)
                                <img src="{{ asset('storage/signatures/' . $principalSignature->image) }}" alt=""
                                    style="height: 20px;width:60px;object-fit: contain;">
                            @endif

                            <p style="text-align: center; font-size:12px;padding:0%">
                                Principal
                            </p>
                        </span>
                    </div>
                </div>
            </div>
            <div style="
                    float: left;
                    margin: 15px 20px 35px 20px;
                    border-radius: 7px;
                    height: 300px;
                    width: 200px;
                    background: rgb(245, 243, 243);
                    display: none;
                "
                class="show-id-card-back-side">
                <div
                    style="
                    padding: 7.5px;
                    display: flex;
                    flex-direction: column;
                    justify-content: space-between;
                    box-sizing: border-box;
                    height: 100%;
                    ">
                    <div>
                        <div class="text-center">
                            <img src="{{ get_logo() }}" alt="" style="height: 52px; object-fit: contain"
                                class="text-center" />
                        </div>
                        <div style="margin-top: 10px; font-size: 12px; line-height: 15px">
                            <li>
                                <span style="min-width: 80px; display: inline-block">Guidance</span>
                                <span>: {{ $settings['guidance'] }}</span>
                            </li>
                            <li>
                                <span style="min-width: 80px; display: inline-block">Academic Office</span>
                                <span>: {{ $settings['academic_office'] }}</span>
                            </li>
                            <li>
                                <span style="min-width: 80px; display: inline-block">Tuition Fee</span>
                                <span>: {{ $settings['tuition_fee'] }}</span>
                            </li>
                            <li>
                                <span style="min-width: 80px; display: inline-block">Exam Office</span>
                                <span>: {{ $settings['exam_office'] }}</span>
                            </li>
                        </div>
                        <p
                            style="
                        margin-top: 10px;
                        font-weight: 500;
                        font-size: 15px;
                        line-height: 16px;
                        ">
                            Anyone finding this lost <br> Identity Card is requested to <br> return to the
                            principal.
                        </p>
                    </div>
                    <div style="font-size: 12px; line-height: 14px" class="text-center id-card-back-footer">
                        <li class="fw700">{{ get_option('school_name') }}</li>
                        <li>{{ $settings['address'] }}</li>
                        <li>Phone: {{ $settings['phone'] }}</li>
                        <li class="fw700">
                            Web: <a href="{{ $settings['website_link'] }}">{{ $settings['website_link'] }}</a>
                        </li>
                    </div>
                </div>
            </div>


            @if ($key != 0 && ($key + 1) % 9 == 0)
                <div class="clearfix"></div>
                <div class="page2el" style="margin: 10px;">
                </div>
            @endif
        @endforeach
    </div>

    <div style="clear: both;"></div>
@endsection
@section('scripts')
    <script>
        function showIdCardBackSide() {
            console.log('1 :>> ');
            var backSideElements = document.getElementsByClassName("show-id-card-back-side");
            var frontSideElements = document.getElementsByClassName("show-id-card-front-side");

            // Loop through the collection of elements with the specified class and set their display style
            for (var i = 0; i < backSideElements.length; i++) {
                backSideElements[i].style.display = "block";
            }

            for (var j = 0; j < frontSideElements.length; j++) {
                frontSideElements[j].style.display = "none";
            }
        }

        function hideIdCardBackSide() {
            console.log('3 :>> ');
            var backSideElements = document.getElementsByClassName("show-id-card-back-side");
            var frontSideElements = document.getElementsByClassName("show-id-card-front-side");

            // Loop through the collection of elements with the specified class and set their display style
            for (var i = 0; i < backSideElements.length; i++) {
                backSideElements[i].style.display = "none";
            }

            for (var j = 0; j < frontSideElements.length; j++) {
                frontSideElements[j].style.display = "block";
            }
        }
    </script>
@endsection
