import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_generic_dropdown.dart';
import 'package:mighty_school/common/widget/custom_title.dart';
import 'package:mighty_school/feature/academic_configuration/class/controller/class_controller.dart';
import 'package:mighty_school/feature/academic_configuration/group/controller/group_controller.dart';
import 'package:mighty_school/feature/students_information/student/controller/student_controller.dart';
import 'package:mighty_school/feature/students_information/student/domain/model/student_model.dart';



class SelectStudentWidget extends StatelessWidget {
  const SelectStudentWidget({super.key});

  @override
  Widget build(BuildContext context) {
    return Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
        const CustomTitle(title: "student"),
        GetBuilder<StudentController>(
          initState: (state) {
            if(Get.find<ClassController>().selectedClassItem != null
            && Get.find<GroupController>().groupItem != null){
              if (Get.find<StudentController>().studentModel == null) {
                Get.find<StudentController>().getStudentList(
                    Get.find<ClassController>().selectedClassItem!.id!,
                    Get.find<GroupController>().groupItem!.id!, null, "", 1);
              }
            }
          },
          builder: (studentController) {
            StudentModel? studentModel = studentController.studentModel;
            List<StudentItem> students = studentModel?.data ?? [];

            return Padding(padding: const EdgeInsets.symmetric(vertical: 8.0),
              child: CustomGenericDropdown<StudentItem>(
                title: "select_student",
                items: students,
                selectedValue: studentController.selectedStudentItem,
                onChanged: (val) {
                  studentController.setSelectedStudent(val!);
                },
                getLabel: (item) => item.name ?? '',
              ),
            );
          },
        ),
      ],
    );
  }
}
