import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_generic_dropdown.dart';
import 'package:mighty_school/feature/staff_information/designation/controller/designation_controller.dart';

class ChangeDesignationWidget extends StatefulWidget {
  const ChangeDesignationWidget({super.key});

  @override
  State<ChangeDesignationWidget> createState() => _ChangeDesignationWidgetState();
}

class _ChangeDesignationWidgetState extends State<ChangeDesignationWidget> {
  @override
  void initState() {
    if(Get.find<DesignationController>().designationModel == null){
      Get.find<DesignationController>().getDesignationList(1);
    }
    super.initState();
  }
  @override
  Widget build(BuildContext context) {
    return GetBuilder<DesignationController>(
        builder: (designationController) {
          return Padding(padding: const EdgeInsets.symmetric(vertical: 8.0),
            child: CustomGenericDropdown(width: Get.width,
              title: "${"designation".tr}: ${designationController.designationName??"".tr}",
              items: designationController.designationModel?.data?.data??[],
              selectedValue: designationController.selectedDesignationItem,
              onChanged: (val){
                designationController.selectDesignation(val!, change: true);
              }, getLabel: (item) => item.name ?? '',
            ),);
        }
    );
  }
}
