import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/confirmation_dialog.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/edit_delete_section.dart';
import 'package:mighty_school/common/widget/numbering_widget.dart';
import 'package:mighty_school/feature/staff_information/designation/controller/designation_controller.dart';
import 'package:mighty_school/feature/staff_information/designation/domain/models/designation_model.dart';
import 'package:mighty_school/feature/staff_information/designation/presentation/widgets/create_new_designation_widget.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';

class DesignationItemWidget extends StatelessWidget {
  final DesignationItem? designationItem;
  final int index;
  const DesignationItemWidget({super.key, this.designationItem, required this.index,});

  @override
  Widget build(BuildContext context) {
    return ResponsiveHelper.isDesktop(context)?
    Row(spacing: Dimensions.paddingSizeDefault, children: [
     NumberingWidget(index: index),
      Expanded(child: Text("${designationItem?.name}", style: textMedium.copyWith(fontSize: Dimensions.fontSizeDefault),)),

        EditDeleteSection(horizontal: true, onEdit: (){
          Get.dialog(CreateNewDesignationWidget(designationItem: designationItem));
        },
          onDelete: (){
            Get.dialog(ConfirmationDialog(
              title: "designation",
              content: "designation",
              onTap: (){
                Get.back();
                Get.find<DesignationController>().deleteDesignation(designationItem!.id!);
              },));

          },)
      ],
    ) :
    CustomContainer(borderRadius: Dimensions.paddingSizeExtraSmall,
      child: Row(spacing: Dimensions.paddingSizeExtraSmall, children: [
          NumberingWidget(index: index),
          Expanded(child: Text("${designationItem?.name}", style: textMedium.copyWith(fontSize: Dimensions.fontSizeDefault),),),
          EditDeleteSection(horizontal: true, onEdit: (){
            Get.dialog(CreateNewDesignationWidget(designationItem: designationItem));
          },
            onDelete: (){
              Get.dialog(ConfirmationDialog(
                title: "designation",
                content: "designation",
                onTap: (){
                  Get.back();
                  Get.find<DesignationController>().deleteDesignation(designationItem!.id!);
                },));

          },)
        ],
      ),
    );
  }
}