import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/layout/list_layout_widget.dart';
import 'package:mighty_school/feature/routine_management/assignment/controller/assignment_controller.dart';
import 'package:mighty_school/feature/routine_management/assignment/domain/models/assignment_model.dart';
import 'package:mighty_school/feature/routine_management/assignment/presentation/widgets/assignment_item_widget.dart';
import 'package:mighty_school/feature/routine_management/assignment/presentation/widgets/create_new_assignment_widget.dart';
import 'package:mighty_school/util/dimensions.dart';

class AssignmentListWidget extends StatelessWidget {
  final ScrollController scrollController;
  const AssignmentListWidget({super.key, required this.scrollController});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<AssignmentController>(
      initState: (state) => Get.find<AssignmentController>().getAssignmentList(1),
      builder: (assignmentController) {
        final assignmentModel = assignmentController.assignmentModel;
        final assignmentData = assignmentModel?.data;
        return GenericListSection<AssignmentItem>(
          sectionTitle: "routine_management".tr,
          pathItems: [ "assignment".tr],
          addNewTitle: "add_new_assignment".tr,
          onAddNewTap: () => Get.dialog(
            const Dialog(child: Padding(padding: EdgeInsets.all(Dimensions.paddingSizeDefault),
              child: CreateNewAssignmentWidget()))),
          headings: const ["assignment", "description", "deadline", "class", "section", "subject"],
          scrollController: scrollController,
          isLoading: assignmentModel == null,
          totalSize: assignmentData?.total ?? 0,
          offset: assignmentData?.currentPage ?? 0,
          onPaginate: (offset) async =>
          await assignmentController.getAssignmentList(offset ?? 1),
          items: assignmentData?.data ?? [],
          itemBuilder: (item, index) => AssignmentItemWidget(index: index, assignmentItem: item),
        );
      },
    );
  }
}
