import 'package:mighty_school/feature/academic_configuration/subject/domain/model/subject_model.dart';

class ChildrenSubjectsModel {
  bool? status;
  String? message;
  List<SubjectItem>? data;

  ChildrenSubjectsModel({this.status, this.message, this.data});

  ChildrenSubjectsModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    message = json['message'];
    if (json['data'] != null) {
      data = <SubjectItem>[];
      json['data'].forEach((v) {
        data!.add(SubjectItem.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['status'] = status;
    data['message'] = message;
    if (this.data != null) {
      data['data'] = this.data!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

