import 'package:get/get_connect/http/src/response/response.dart';
import 'package:mighty_school/api_handle/api_client.dart';
import 'package:mighty_school/util/app_constants.dart';

class PackageRepository{
  final ApiClient apiClient;
  PackageRepository({required this.apiClient});


  Future<Response?> getPackageList(int page) async {
    return await apiClient.getData("${AppConstants.plans}?page=$page&perPage=10");
  }



  Future<Response?> subscriptionPlanUpdate(int planId, int instituteId) async {
    return await apiClient.postData(AppConstants.subscriptionPlanUpdate,{
      "plan_id": planId,
      "institute_id": instituteId,
    });
  }

  Future<Response> getSubscriptionPackageList() async {
    return await apiClient.getData("${AppConstants.subscriptionPackageList}?perPage=100&page=1");
  }

  Future<Response?> getSaasPaymentGateway() async {
    return await apiClient.getData(AppConstants.saasPayment);
  }

}