import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_image.dart';
import 'package:mighty_school/feature/landing_page/domain/models/mobile_app_model.dart';
import 'package:mighty_school/feature/landing_page/logic/landing_page_controller.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/app_constants.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/images.dart';
import 'package:mighty_school/util/styles.dart';

class StayConnectedWidget extends StatelessWidget {
  const StayConnectedWidget({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<LandingPageController>(
      initState: (val){
        final landingPageController = Get.find<LandingPageController>();
        if (landingPageController.mobileAppModel == null) {
          landingPageController.getMobileAppData();
        }
      },
      builder: (landingPageController) {
        MobileAppModel? mobileAppModel = landingPageController.mobileAppModel;
        final isDesktop = ResponsiveHelper.isDesktop(context);
        return (mobileAppModel != null && mobileAppModel.data?.isNotEmpty == true)?

         isDesktop?
        Center(
          child: SizedBox(width: Dimensions.webMaxWidth,
            child: Padding(padding: const EdgeInsets.symmetric(vertical: 50, horizontal: Dimensions.paddingSizeDefault),
              child: SizedBox(width: Dimensions.webMaxWidth,
                child: Center(
                  child: Row(spacing: Dimensions.paddingSizeExtraLarge,crossAxisAlignment: CrossAxisAlignment.start, children: [
                      CustomImage(width: 400, height: 400, fit: BoxFit.fitWidth,
                          image: "${AppConstants.imageBaseUrl}/mobile_app_sections/${mobileAppModel.data?.first.image}",
                          placeholder: Images.stayConnected,  radius: 10),
                      Expanded(
                        child: Column( crossAxisAlignment: CrossAxisAlignment.start, spacing: Dimensions.paddingSizeDefault, children: [
                            Text("mobile_app".tr, style: textMedium.copyWith(color: Theme.of(context).primaryColor, fontSize: 20)),
                            Text(mobileAppModel.data?.first.title??'', style: textBold.copyWith(fontSize: 40, color: Theme.of(context).colorScheme.primary)),
                            Container(height: 3, width: 60, decoration: BoxDecoration(color: Theme.of(context).primaryColor, borderRadius: BorderRadius.circular(50))),
                            Text(mobileAppModel.data?.first.description??'', style: textRegular.copyWith(fontSize: 20, color: Theme.of(context).hintColor),),
                            FeatureItemWidget(title: mobileAppModel.data?.first.featureOne),
                            FeatureItemWidget(title: mobileAppModel.data?.first.featureTwo),
                            FeatureItemWidget(title: mobileAppModel.data?.first.featureThree),
                            const SizedBox(height: Dimensions.paddingSizeDefault),

                             Row(spacing: Dimensions.paddingSizeDefault, children: [
                                InkWell(onTap: ()=> AppConstants.openUrl(mobileAppModel.data?.first.playStoreLink??''),
                                    child: const CustomImage(image: Images.playStore, height: 40, localAsset: true,)),

                               InkWell(onTap: ()=> AppConstants.openUrl(mobileAppModel.data?.first.appStoreLink??''),
                                    child: const CustomImage(image: Images.appStore,height: 40, localAsset: true,))
                              ],
                            )
                          ],
                        ),
                      )
                    ],
                  ),
                ),
              ),
            ),
          ),
        ):

         Padding(padding: const EdgeInsets.all(Dimensions.paddingSizeDefault), child: Column(spacing: Dimensions.paddingSizeDefault ,mainAxisAlignment: MainAxisAlignment.center, children: [
             CustomImage(width: Get.width,image: "${AppConstants.imageBaseUrl}/mobile_app_sections/${mobileAppModel.data?.first.image}"),
             Text("mobile_app".tr, style: textMedium.copyWith(color: Theme.of(context).primaryColor, fontSize: Dimensions.paddingSizeDefault)),
             Text(mobileAppModel.data?.first.title??'', style: textBold.copyWith(fontSize: Dimensions.fontSizeExtraLarge, color: Theme.of(context).colorScheme.primary)),
             Container(height: 3, width: 60, decoration: BoxDecoration(color: Theme.of(context).primaryColor, borderRadius: BorderRadius.circular(50))),
             Text(mobileAppModel.data?.first.description??'', style: textRegular.copyWith(fontSize: Dimensions.paddingSizeDefault, color: Theme.of(context).hintColor),),


            Column(crossAxisAlignment: CrossAxisAlignment.start, spacing: Dimensions.paddingSizeSmall, children: [
              FeatureItemWidget(title: mobileAppModel.data?.first.featureOne),
              FeatureItemWidget(title: mobileAppModel.data?.first.featureTwo),
              FeatureItemWidget(title: mobileAppModel.data?.first.featureThree),
            ],),

             const SizedBox(height: Dimensions.paddingSizeDefault),

             Row(mainAxisAlignment: MainAxisAlignment.center, spacing: Dimensions.paddingSizeDefault, children: [
               InkWell(onTap: ()=> AppConstants.openUrl(mobileAppModel.data?.first.playStoreLink??''),
                   child: const CustomImage(image: Images.playStore, height: 40, localAsset: true,)),

               InkWell(onTap: ()=> AppConstants.openUrl(mobileAppModel.data?.first.appStoreLink??''),
                   child: const CustomImage(image: Images.appStore,height: 40, localAsset: true,))
             ])
           ])) :const SizedBox();
      }
    );
  }
}

class FeatureItemWidget extends StatelessWidget {
  final String? title;
  const FeatureItemWidget({super.key, this.title});

  @override
  Widget build(BuildContext context) {
    final isDesktop = ResponsiveHelper.isDesktop(context);
    return Row(spacing : Dimensions.paddingSizeSmall,mainAxisAlignment:isDesktop?MainAxisAlignment.start: MainAxisAlignment.center,children: [
      Icon(Icons.check_circle, color: Theme.of(context).primaryColor, size: 18,),
      Text(title??'', style: textBold.copyWith(color: Theme.of(context).colorScheme.primary, fontSize: 16),)
    ],);
  }
}
