import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_button.dart';
import 'package:mighty_school/common/widget/custom_image.dart';
import 'package:mighty_school/feature/landing_page/domain/models/about_us_model.dart';
import 'package:mighty_school/feature/landing_page/logic/landing_page_controller.dart';
import 'package:mighty_school/feature/landing_page/presentation/generic_school/about_us_loading_screen.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/app_constants.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';

class AboutUsWidget extends StatelessWidget {
  const AboutUsWidget({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<LandingPageController>(
      initState: (val){
        final landingPageController = Get.find<LandingPageController>();
        if (landingPageController.aboutUsModel == null) {
          landingPageController.getAboutData();
        }
      },
      builder: (landingPageController) {
        AboutUsModel? aboutUsModel = landingPageController.aboutUsModel;

        return Container(
          color: Theme.of(context).primaryColorDark.withValues(alpha: 0.1),
          padding: EdgeInsets.symmetric(vertical: ResponsiveHelper.isDesktop(context) ? 50 : Dimensions.paddingSizeExtraLarge),
          child: ResponsiveHelper.isDesktop(context) ? Center(
            child: aboutUsModel != null?
            SizedBox(width: Dimensions.webMaxWidth,
              child: Row(children: [
                  CustomImage(width: 445,height: 450, image: "${AppConstants.imageBaseUrl}/about_us/${aboutUsModel.data?.image}"),
                  const SizedBox(width: 40),
                  Expanded(
                    child: Column(mainAxisAlignment: MainAxisAlignment.center, crossAxisAlignment: CrossAxisAlignment.start, children: [
                        Text('about_us'.tr, style: textMedium.copyWith(fontSize: 20, color: Theme.of(context).primaryColor)),
                        Text(aboutUsModel.data?.title ?? '',
                            style: textBold.copyWith(color: Theme.of(context).colorScheme .primary, fontSize: 40)),
                        Text( aboutUsModel.data?.description ?? 'We provide a nurturing environment, a challenging curriculum, and a dedicated faculty to ensure student success.',
                          maxLines: 5, overflow: TextOverflow.ellipsis,
                          style: textRegular.copyWith(color: Theme.of(context).hintColor),),
                        const SizedBox(height: 50),
                        SizedBox(width: 200,child: CustomButton(onTap: () {}, text: "learn_more_about_us".tr)),
                      ],
                    ),
                  ),
                ]),
            ):const AboutUsLoadingScreen()) :
              aboutUsModel != null?
          Padding(padding: const EdgeInsets.symmetric(horizontal: Dimensions.paddingSizeDefault), child: Column(children: [
                CustomImage( width: Get.width, image: "${AppConstants.imageBaseUrl}/about_us/${aboutUsModel.data?.image}"),
                const SizedBox(height: Dimensions.paddingSizeDefault),
                Text('about_us'.tr, style: textMedium.copyWith(
                    fontSize: Dimensions.paddingSizeDefault, color: Theme.of(context).primaryColor)),
                Text(aboutUsModel.data?.title ?? '',style: textBold.copyWith(color: Theme.of(context).colorScheme.primary, fontSize: Dimensions.fontSizeExtraLarge),),
                Text(aboutUsModel.data?.description ?? '',maxLines: 5,overflow: TextOverflow.ellipsis,style: textRegular.copyWith(color: Theme.of(context).hintColor),),
                SizedBox(width: 200,
                    child:
                    CustomButton(onTap: () {

                    }, text: "learn_more_about_us".tr)),
                const SizedBox(height: Dimensions.paddingSizeExtraLarge),
              ],
            ),
          ):const AboutUsLoadingScreen(),
        );
      },
    );
  }


}