import 'package:flutter/material.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/custom_item_text_widget.dart';
import 'package:mighty_school/common/widget/numbering_widget.dart';
import 'package:mighty_school/feature/exam_management/exam_result/domain/models/exam_result_model.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/dimensions.dart';

class ExamResultItemWidget extends StatelessWidget {
  final ResultItem? resultItem;
  final int index;
  const ExamResultItemWidget({super.key, this.resultItem, required this.index});

  @override
  Widget build(BuildContext context) {
    return ResponsiveHelper.isDesktop(context)?
    Row(spacing: Dimensions.paddingSizeDefault, children: [
      NumberingWidget(index: index),
      Expanded(child: CustomItemTextWidget(text: resultItem?.exam?.name??'')),
      Expanded(child: CustomItemTextWidget(text: resultItem?.student?.firstName??'')),
      Expanded(child: CustomItemTextWidget(text: resultItem?.gradePoint??'')),
      Expanded(child: CustomItemTextWidget(text: resultItem?.grade??'')),
      Expanded(child: CustomItemTextWidget(text: resultItem?.totalMarks??'')),
    ],):
    CustomContainer(child: Column(children: [
        CustomItemTextWidget(text: resultItem?.exam?.name??""),
        CustomItemTextWidget(text: resultItem?.student?.firstName??''),
        CustomItemTextWidget(text: resultItem?.gradePoint??''),
        CustomItemTextWidget(text: resultItem?.grade??""),
        CustomItemTextWidget(text: resultItem?.totalMarks??""),
      ],
    ),);
  }
}
