<?php

namespace Modules\Examination\Models;

use Illuminate\Database\Eloquent\Model;
use Modules\Academic\Models\ClassModel;

class ExamCode extends Model
{
    protected $fillable = [
        'institute_id',
        'branch_id',
        'session_id',
        'class_model_id',
        'short_code_id',
        'short_code_title',
        'short_code_note',
        'default_id',
        'total_mark',
        'accept_percent',
        'pass_mark',
    ];

    public function class()
    {
        return $this->belongsTo(ClassModel::class, 'class_model_id', 'id')->select('id', 'class_name');
    }

    public function shortCode()
    {
        return $this->belongsTo(Grade::class, 'short_code_id', 'id');
    }
}
