<?php

namespace Modules\Academic\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;
use Modules\Academic\Models\Student;
use Modules\Authentication\Models\User;

class StudentFactory extends Factory
{
    protected $model = Student::class;

    public function definition()
    {
        $faker = $this->faker;
        $name = $faker->name;
        $gender = $faker->randomElement(['men', 'women']);

        // ✅ Create user first
        $user = User::factory()->create([
            'name' => $name,
            'email' => $faker->unique()->safeEmail,
            'phone' => $faker->unique()->phoneNumber,
            'password' => Hash::make('12345678'),
            'role_id' => 7, // Optional: for your DB column
            'status' => 1,
            'user_type' => 'Student',
            'email_verified_at' => now(),
            'image' => $faker->numberBetween(1, 12).'.png',
        ]);

        // ✅ Assign Student role properly via spatie/laravel-permission
        $user->assignRole('Student');

        return [
            'user_id' => $user->id,

            // Foreign keys
            'institute_id' => 1,
            'branch_id' => 1,
            'parent_id' => $faker->numberBetween(1, 10),

            // Basic info
            'first_name' => $faker->firstName,
            'last_name' => $faker->lastName,
            'native_name' => $faker->name,
            'nick_name' => $faker->firstName,
            'phone' => $faker->unique()->phoneNumber,
            'gender' => $gender === 'men' ? 'Male' : 'Female',
            'birthday' => $faker->date('Y-m-d', '-18 years'),
            'blood_group' => $faker->randomElement(['A+', 'A-', 'B+', 'B-', 'AB+', 'AB-', 'O+', 'O-']),
            'religion' => $faker->randomElement(['Islam', 'Christianity', 'Hinduism', 'Buddhism', 'Other']),
            'sect' => $faker->word,
            'ethnic' => $faker->word,
            'birth_certificate_no' => $faker->unique()->numerify('BC#######'),
            'nid_no' => $faker->unique()->numerify('NID#########'),
            'application_number' => $faker->unique()->numerify('APP#####'),
            'date_of_admission' => $faker->date('Y-m-d', 'now'),
            'admission_place' => $faker->city,
            'serial_no' => $faker->unique()->numberBetween(1000, 9999),
            'roll_no' => $faker->numberBetween(1, 200),
            'register_no' => $faker->unique()->numberBetween(1000, 9999),
            'class_id' => $faker->numberBetween(1, 12),
            'session_id' => '2023-2024',
            'group' => $faker->randomElement(['Science', 'Commerce', 'Arts']),
            'section_id' => $faker->randomLetter,
            'student_category_id' => $faker->numberBetween(1, 5),
            'address' => $faker->address,

            // SSC Info
            'school_name' => $faker->company,
            'school_address' => $faker->address,
            'board' => $faker->randomElement(['Dhaka', 'Chittagong', 'Rajshahi', 'Comilla']),
            'center' => $faker->city,
            'passing_year' => $faker->year('-5 years'),
            'ssc_session' => '2018-2019',
            'board_roll' => $faker->numerify('BR######'),
            'registration_number' => $faker->numerify('REG######'),
            'gpa_with_4th' => $faker->randomFloat(2, 2, 5),
            'gpa_without_4th' => $faker->randomFloat(2, 2, 5),
            'total_a_plus' => $faker->numberBetween(0, 10),
            'subject_4th' => $faker->word,
            'grade_4th_sub' => $faker->randomElement(['A+', 'A', 'A-', 'B+', 'B', 'C']),

            // SSC Grades
            'bangla' => $faker->randomElement(['A+', 'A', 'B']),
            'english' => $faker->randomElement(['A+', 'A', 'B']),
            'math' => $faker->randomElement(['A+', 'A', 'B']),
            'ict' => $faker->randomElement(['A+', 'A', 'B']),
            'religion_sub' => $faker->randomElement(['A+', 'A', 'B']),
            'career_education' => $faker->randomElement(['A+', 'A', 'B']),
            'physical_education' => $faker->randomElement(['A+', 'A', 'B']),
            'physics' => $faker->randomElement(['A+', 'A', 'B']),
            'chemistry' => $faker->randomElement(['A+', 'A', 'B']),
            'bk' => $faker->randomElement(['A+', 'A', 'B']),
            'biology' => $faker->randomElement(['A+', 'A', 'B']),
            'higher_math' => $faker->randomElement(['A+', 'A', 'B']),
            'business_ent' => $faker->randomElement(['A+', 'A', 'B']),
            'accounting' => $faker->randomElement(['A+', 'A', 'B']),
            'management' => $faker->randomElement(['A+', 'A', 'B']),
            'finance_banking' => $faker->randomElement(['A+', 'A', 'B']),
            'general_science' => $faker->randomElement(['A+', 'A', 'B']),
            'civic_citizenship' => $faker->randomElement(['A+', 'A', 'B']),
            'geography' => $faker->randomElement(['A+', 'A', 'B']),
            'economics' => $faker->randomElement(['A+', 'A', 'B']),
            'history' => $faker->randomElement(['A+', 'A', 'B']),

            // HSC Info
            'hsc_roll' => $faker->numerify('HSC#####'),
            'hsc_year' => $faker->year('-2 years'),
            'hsc_reg' => $faker->numerify('HR#####'),
            'hsc_session' => '2020-2021',
            'hsc_gpa' => $faker->randomFloat(2, 2, 5),
            'hsc_total_a_plus' => $faker->numberBetween(0, 10),
            'hsc_total_appeared' => $faker->numberBetween(1, 200),
            'hsc_total_passed' => $faker->numberBetween(1, 200),
            'hsc_percentage' => $faker->randomFloat(2, 40, 100),
            'hsc_tec' => $faker->word,
            'hsc_subject' => $faker->word,
            'hsc_total_combined' => $faker->word,
            'hsc_subject_4th' => $faker->word,
            'hsc_grade_4th_sub' => $faker->randomElement(['A+', 'A', 'B']),
            'hsc_bangla' => $faker->randomElement(['A+', 'A', 'B']),
            'hsc_english' => $faker->randomElement(['A+', 'A', 'B']),
            'hsc_ict' => $faker->randomElement(['A+', 'A', 'B']),
            'hsc_physics' => $faker->randomElement(['A+', 'A', 'B']),
            'hsc_chemistry' => $faker->randomElement(['A+', 'A', 'B']),
            'hsc_biology' => $faker->randomElement(['A+', 'A', 'B']),
            'hsc_higher_math' => $faker->randomElement(['A+', 'A', 'B']),
            'hsc_businessEnt' => $faker->randomElement(['A+', 'A', 'B']),
            'hsc_accounting' => $faker->randomElement(['A+', 'A', 'B']),
            'hsc_management' => $faker->randomElement(['A+', 'A', 'B']),
            'hsc_financeBanking' => $faker->randomElement(['A+', 'A', 'B']),
            'hsc_generalScience' => $faker->randomElement(['A+', 'A', 'B']),
            'hsc_civicCitizenship' => $faker->randomElement(['A+', 'A', 'B']),
            'hsc_geography' => $faker->randomElement(['A+', 'A', 'B']),
            'hsc_economics' => $faker->randomElement(['A+', 'A', 'B']),
            'hsc_history' => $faker->randomElement(['A+', 'A', 'B']),

            // Parents
            'father_name' => $faker->name('male'),
            'father_phone_no' => $faker->phoneNumber,
            'father_occupation' => $faker->jobTitle,
            'father_designation' => $faker->jobTitle,
            'father_office_address' => $faker->address,
            'father_nid' => $faker->numerify('NID#########'),

            'mother_name' => $faker->name('female'),
            'mother_phone_no' => $faker->phoneNumber,
            'mother_occupation' => $faker->jobTitle,
            'mother_designation' => $faker->jobTitle,
            'mother_office_address' => $faker->address,
            'mother_nid' => $faker->numerify('NID#########'),

            'monthly_income_parents' => $faker->numberBetween(20000, 200000),
            'monthly_income_family' => $faker->numberBetween(30000, 300000),

            // Guardian
            'local_guardian_relation' => $faker->randomElement(['Uncle', 'Aunt', 'Brother', 'Sister']),
            'local_guardian_name' => $faker->name,
            'local_guardian_occupation' => $faker->jobTitle,
            'local_guardian_designation' => $faker->jobTitle,
            'local_guardian_phone_res' => $faker->phoneNumber,
            'local_guardian_phone_office' => $faker->phoneNumber,
            'local_guardian_nid' => $faker->numerify('NID#########'),
            'local_guardian_organization' => $faker->company,
            'local_guardian_address' => $faker->address,

            // Addresses
            'present_address' => $faker->address,
            'present_address_phone' => $faker->phoneNumber,
            'permanent_address' => $faker->address,
            'permanent_district' => $faker->city,

            // Co-curricular activities
            'co_curricular_activities_sports' => $faker->text(20),
            'co_curricular_activities_clubs' => $faker->text(20),
            'co_curricular_activities_others' => $faker->text(20),
            'vital_sports' => $faker->text(20),
            'vital_sports_college_team' => $faker->text(20),
            'vital_sports_inter_class' => $faker->text(20),
            'vital_sports_awards' => $faker->text(20),
            'science_club' => $faker->text(20),
            'science_club_awards' => $faker->text(20),
            'science_fair' => $faker->text(20),
            'science_fair_awards' => $faker->text(20),
            'com_arts_sci_club' => $faker->text(20),
            'com_arts_sci_awards' => $faker->text(20),
            'notre_dame_volunteers_alliance' => $faker->text(20),
            'notre_dame_volunteers_alliance_awards' => $faker->text(20),
            'debate_collage' => $faker->text(20),
            'inter_collage' => $faker->text(20),
            'inter_collage_awards' => $faker->text(20),

            // Scholarships
            'scholarship_type' => $faker->word,
            'annual_lump_grant_1st_year_tk' => $faker->numberBetween(5000, 50000),
            'annual_lump_grant_2nd_year_tk' => $faker->numberBetween(5000, 50000),
            'monthly_tk' => $faker->numberBetween(1000, 10000),
            'period_total_months' => $faker->numberBetween(1, 12),
            'from_year' => $faker->year('-2 years'),
            'to_year' => $faker->year(),

            // Misc
            'dropped_date' => $faker->optional()->date(),
            'recommendation_gives_on' => $faker->sentence,
            'reason' => $faker->sentence,
            'remarks' => $faker->paragraph,
            'promoted_to_class_xll' => $faker->numberBetween(11, 12),

            // General Info
            'state' => $faker->state,
            'country' => 'Bangladesh',
            'activities' => $faker->word,
            'access_key' => '12345678',
            'nationality' => 'Bangladeshi',
            'tc_date' => $faker->optional()->date(),

            // Status
            'status' => '1',

            'created_at' => now(),
            'updated_at' => now(),
            'deleted_at' => null,
        ];
    }
}
