import 'package:get/get_connect/http/src/response/response.dart';
import 'package:mighty_school/api_handle/api_client.dart';
import 'package:mighty_school/feature/student_attendance_information/student_attendance/domain/models/student_attendance_body.dart';
import 'package:mighty_school/util/app_constants.dart';

class StudentAttendanceRepository{
  final ApiClient apiClient;
  StudentAttendanceRepository({required this.apiClient});



  Future<Response?> getStudentListForAttendance(int classId, int sectionId, int periodId, String date) async {
    return await apiClient.getData("${AppConstants.studentAttendance}?class_id=$classId&section_id=$sectionId&period_id=$periodId&date=$date");
  }

  Future<Response?> getStudentAttendanceList(int page) async {
    return await apiClient.getData("${AppConstants.attendance}?page=$page&perPage=10");
  }

  Future<Response?> createNewStudentAttendance(StudentAttendanceBody attendanceBody) async {
    return await apiClient.postData(AppConstants.studentAttendance, attendanceBody.toJson());
  }

  Future<Response?> updateAttendance(StudentAttendanceBody attendanceBody, int id) async {
    return await apiClient.putData("${AppConstants.attendance}/$id", attendanceBody.toJson());
  }

  Future<Response?> deleteAttendance (int id) async {
    return await apiClient.deleteData("${AppConstants.attendance}/$id");
  }

  Future<Response?> studentQrAttendance (String qrCode) async {
    return await apiClient.postData(AppConstants.qrAttendance,{
      "qr_code": qrCode,
    });
  }


  Future<Response?> studentAttendanceReport({
    required int classId, required int sectionId,
    int? studentId, String? fromDate,
    String? toDate, String? percentage}) async {
    final queryParams = {
      'class_id': classId.toString(),
      'section_id': sectionId.toString(),
      if (studentId != null) 'student_id': studentId.toString(),
      if (fromDate != null && fromDate.isNotEmpty) 'from_date': fromDate,
      if (toDate != null && toDate.isNotEmpty) 'to_date': toDate,
      if (percentage != null && percentage.isNotEmpty) 'percentage': percentage,
    };
    final uri = Uri.parse(AppConstants.studentAttendanceReport).replace(queryParameters: queryParams);
    return await apiClient.getData(uri.toString());
  }


  Future<Response?> studentAbsentFineReport({
    required int classId, required int sectionId,
    int? studentId, String? fromDate,
    String? toDate, String? percentage}) async {
    final queryParams = {
      'class_id': classId.toString(),
      'section_id': sectionId.toString(),
      if (studentId != null) 'student_id': studentId.toString(),
      if (fromDate != null && fromDate.isNotEmpty) 'from_date': fromDate,
      if (toDate != null && toDate.isNotEmpty) 'to_date': toDate,

    };
    final uri = Uri.parse(AppConstants.studentAbsentFineReport).replace(queryParameters: queryParams);
    return await apiClient.getData(uri.toString());
  }



}