
import 'package:get/get.dart';
import 'package:mighty_school/api_handle/api_checker.dart';
import 'package:mighty_school/common/widget/custom_snackbar.dart';
import 'package:mighty_school/feature/staff_information/designation/domain/models/designation_model.dart';
import 'package:mighty_school/feature/staff_information/designation/domain/repository/designation_repository.dart';
import 'package:mighty_school/util/app_constants.dart';

class DesignationController extends GetxController implements GetxService{
  final DesignationRepository designationRepository;
  DesignationController({required this.designationRepository});




  bool isLoading = false;
  DesignationModel? designationModel;
  Future<void> getDesignationList(int offset) async {
    Response? response = await designationRepository.getDesignationList(offset);
    if (response?.statusCode == 200) {
      if(offset == 1){
        designationModel = DesignationModel.fromJson(response?.body);
      }else{
        designationModel?.data?.data?.addAll(DesignationModel.fromJson(response?.body).data!.data!);
        designationModel?.data?.currentPage = DesignationModel.fromJson(response?.body).data?.currentPage;
        designationModel?.data?.total = DesignationModel.fromJson(response?.body).data?.total;
      }
      isLoading = false;

    }else{
      isLoading = false;
      ApiChecker.checkApi(response!);
    }
    update();
  }

  // need to return the session name from the session id

  String? designationName;
  getDesignationNameFromId(int id) {
    if (designationModel != null) {
      final designation = designationModel!.data!.data!.firstWhere((element) => element.id == id, orElse: () => DesignationItem(id: -1, name: "Unknown"));
      designationName = designation.name;
    } else {
      designationName = "Unknown";
    }
    update();
  }





  Future<void> createNewDesignation( String name) async {
    isLoading = true;
    update();
    Response? response = await designationRepository.createNewDesignation(name );
    if(response!.statusCode == 200){
      isLoading = false;
      Get.back();
      showCustomSnackBar("added_successfully".tr, isError: false);
      getDesignationList(1);
    }else{
      ApiChecker.checkApi(response);
    }
    isLoading = false;
    update();

  }

  Future<void> updateDesignation( String name, int id) async {
    isLoading = true;
    update();
    Response? response = await designationRepository.updateDesignation(name,  id);
    if(response!.statusCode == 200){
      isLoading = false;
      Get.back();
      showCustomSnackBar("updated_successfully".tr, isError: false);
      getDesignationList(1);
    }else{
      ApiChecker.checkApi(response);
    }
    isLoading = false;
    update();

  }


  Future<void> deleteDesignation(int id) async {
    isLoading = true;
    Response? response = await designationRepository.deleteDesignation(id);
    if (response?.statusCode == 200) {
      showCustomSnackBar("deleted_successfully".tr, isError: false);
      getDesignationList(1);
      isLoading = false;
    }else{
      isLoading = false;
      ApiChecker.checkApi(response!);
    }
    update();
  }



  DesignationItem? selectedDesignationItem;
  void selectDesignation(DesignationItem item, {bool change = false}){
    if(AppConstants.demo){
      showCustomSnackBar("Changes are disabled in the demo version.");
    }else{
      selectedDesignationItem = item;

    }

    update();
  }


}