import 'package:mighty_school/feature/academic_configuration/section/domain/model/section_model.dart';
import 'package:mighty_school/feature/academic_configuration/session/domain/models/session_model.dart';
import 'package:mighty_school/feature/academic_configuration/class/domain/model/class_model.dart';
import 'package:mighty_school/feature/students_information/student/domain/model/student_model.dart';

class AdmitCardModel {
  bool? status;
  String? message;
  Data? data;

  AdmitCardModel({this.status, this.message, this.data});

  AdmitCardModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    message = json['message'];
    data = json['data'] != null ? Data.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['status'] = status;
    data['message'] = message;
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    return data;
  }
}

class Data {
  String? type;
  String? examName;
  List<AdmitCardItem>? data;

  Data({this.type, this.examName, this.data});

  Data.fromJson(Map<String, dynamic> json) {
    type = json['type'];
    examName = json['exam_name'];
    if (json['data'] != null) {
      data = <AdmitCardItem>[];
      json['data'].forEach((v) {
        data!.add(AdmitCardItem.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['type'] = type;
    data['exam_name'] = examName;
    if (this.data != null) {
      data['data'] = this.data!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class AdmitCardItem {
  int? id;
  int? instituteId;
  int? branchId;
  int? sessionId;
  int? studentId;
  int? classId;
  int? sectionId;
  String? roll;
  String? qrCode;
  String? optionalSubject;
  StudentItem? student;
  SessionItem? session;
  ClassItem? classItem;
  SectionItem? section;

  AdmitCardItem(
      {this.id,
        this.instituteId,
        this.branchId,
        this.sessionId,
        this.studentId,
        this.classId,
        this.sectionId,
        this.roll,
        this.qrCode,
        this.optionalSubject,
        this.student,
        this.session,
        this.classItem,
        this.section});

  AdmitCardItem.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    instituteId = json['institute_id'];
    branchId = json['branch_id'];
    sessionId = json['session_id'];
    studentId = json['student_id'];
    classId = json['class_id'];
    sectionId = json['section_id'];
    roll = json['roll'];
    qrCode = json['qr_code'];
    optionalSubject = json['optional_subject'];
    student =
    json['student'] != null ? StudentItem.fromJson(json['student']) : null;
    session =
    json['session'] != null ? SessionItem.fromJson(json['session']) : null;
    classItem = json['class'] != null
        ? ClassItem.fromJson(json['class'])
        : null;
    section =
    json['section'] != null ? SectionItem.fromJson(json['section']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['institute_id'] = instituteId;
    data['branch_id'] = branchId;
    data['session_id'] = sessionId;
    data['student_id'] = studentId;
    data['class_id'] = classId;
    data['section_id'] = sectionId;
    data['roll'] = roll;
    data['qr_code'] = qrCode;
    data['optional_subject'] = optionalSubject;
    return data;
  }
}




