import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/global_widget/custom_web_scroll_view_widget.dart';
import 'package:mighty_school/common/widget/custom_app_bar.dart';
import 'package:mighty_school/common/widget/custom_floating_button.dart';
import 'package:mighty_school/feature/question_bank/question_bank_sources/presentation/widgets/create_new_question_bank_source_widget.dart';
import 'package:mighty_school/feature/question_bank/question_bank_sources/presentation/widgets/question_bank_source_list_widget.dart';

class QuestionBankSourceScreen extends StatefulWidget {
  const QuestionBankSourceScreen({super.key});

  @override
  State<QuestionBankSourceScreen> createState() => _QuestionBankSourceScreenState();
}

class _QuestionBankSourceScreenState extends State<QuestionBankSourceScreen> {
  ScrollController scrollController = ScrollController();
  @override
  Widget build(BuildContext context) {
    return Scaffold(appBar: CustomAppBar(title: "source".tr),
        body: CustomWebScrollView(controller: scrollController, slivers:  [

          SliverToBoxAdapter(child: QuestionBankSourceListWidget(scrollController: scrollController,))
        ],),
        floatingActionButton: CustomFloatingButton(title: "add",
            onTap: () => Get.dialog(Dialog(shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(8)),
                child: const CreateNewQuestionBankSourceWidget()))));
  }
}
