import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/feature/question_bank/question/presentation/widgets/level_filter_widget.dart';
import 'package:mighty_school/feature/question_bank/question/presentation/widgets/source_filter_widget.dart';
import 'package:mighty_school/feature/question_bank/question/presentation/widgets/sub_source_filter_widget.dart';
import 'package:mighty_school/feature/question_bank/question/presentation/widgets/tag_filter_widget.dart';
import 'package:mighty_school/feature/question_bank/question/presentation/widgets/type_filter_widget.dart';
import 'package:mighty_school/util/styles.dart';
class QuestionBankLeftFilterMenu extends StatelessWidget {
  const QuestionBankLeftFilterMenu({super.key});

  @override
  Widget build(BuildContext context) {
    return CustomContainer(horizontalPadding: 0,
        showShadow: false, borderRadius: 5, border: Border.all(color: Theme.of(context).hintColor.withValues(alpha: .25)),
        child: Row(children: [

          Expanded(
            child: ExpansionTile(showTrailingIcon: false,
                title: Row(children: [
                  Expanded(child: Text("type".tr, style: textRegular)),
                  Icon(Icons.keyboard_arrow_down, color: Theme.of(context).hintColor, size: 20)
                ]), children: const [
                  TypeFilterWidget()
                ]),
          ),

          Expanded(
            child: ExpansionTile(showTrailingIcon: false,
                title: Row(children: [
                  Expanded(child: Text("level".tr, style: textRegular)),
                  Icon(Icons.keyboard_arrow_down, color: Theme.of(context).hintColor, size: 20)
                ]), children: const [
                  LevelFilterWidget()
                ]),
          ),


          Expanded(
            child: ExpansionTile(showTrailingIcon: false,
                title: Row(children: [
                  Expanded(child: Text("source".tr, style: textRegular)),
                  Icon(Icons.keyboard_arrow_down, color: Theme.of(context).hintColor, size: 20)
                ]), children: const [
                  SourceFilterWidget(),
                ]),
          ),

          Expanded(
            child: ExpansionTile(showTrailingIcon: false,
                title: Row(children: [
                  Expanded(child: Text("sub_source".tr, style: textRegular)),
                  Icon(Icons.keyboard_arrow_down, color: Theme.of(context).hintColor, size: 20)
                ]), children: const [
                  SubSourceFilterWidget()
                ]),
          ),

          Expanded(
            child: ExpansionTile(showTrailingIcon: false,
                title: Row(children: [
                  Expanded(child: Text("tag".tr, style: textRegular)),
                  Icon(Icons.keyboard_arrow_down, color: Theme.of(context).hintColor, size: 20)
                ]), children: const [
                  TagFilterWidget()
                ]),
          ),



        ]));
  }
}
