
import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_image.dart';
import 'package:mighty_school/feature/landing_page/domain/models/why_choose_us_model.dart';
import 'package:mighty_school/feature/landing_page/logic/landing_page_controller.dart';
import 'package:mighty_school/feature/landing_page/presentation/generic_school/why_choose_us_loading_widget.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/app_constants.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/images.dart';
import 'package:mighty_school/util/styles.dart';

class WhyChooseUsWidget extends StatelessWidget {
  const WhyChooseUsWidget({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<LandingPageController>(
      initState: (val){
        final landingPageController = Get.find<LandingPageController>();
        if (landingPageController.whyChooseUsModel == null) {
          landingPageController.getWhyChooseUsData();
        }
      },
      builder: (landingPageController) {
        WhyChooseUsModel? whyChooseUsModel = landingPageController.whyChooseUsModel;
        final isDesktop = ResponsiveHelper.isDesktop(context);
        return Container(
          width: double.infinity,
          decoration: BoxDecoration(color: Theme.of(context).hintColor.withValues(alpha: 0.1)),
          child: Padding(padding:  EdgeInsets.symmetric(vertical: ResponsiveHelper.isDesktop(context) ? 50 : Dimensions.paddingSizeExtraLarge),
            child: SizedBox(width: Dimensions.webMaxWidth,
              child: Column(mainAxisAlignment: MainAxisAlignment.center, crossAxisAlignment: CrossAxisAlignment.center, children: [
                  Text("why_choose_us".tr, style: textMedium.copyWith(color: Theme.of(context).primaryColor, fontSize: isDesktop?20: Dimensions.paddingSizeDefault)),
                  Text("${"why".tr} ${AppConstants.appName} ${"is_the_right_choice".tr}",
                    style: textBold.copyWith(fontSize: isDesktop? 50 : Dimensions.fontSizeExtraLarge, color: Theme.of(context).colorScheme.primary),
                    textAlign: TextAlign.center),
                  Container(height: 3, width: 60, decoration: BoxDecoration(color: Theme.of(context).primaryColor, borderRadius: BorderRadius.circular(50)),),
                  const SizedBox(height: 40),


                  isDesktop?
                  SizedBox(height: 260,
                    child: whyChooseUsModel != null ? ListView.builder(
                        itemCount: whyChooseUsModel.data?.length,
                        scrollDirection: Axis.horizontal,
                        shrinkWrap: true,
                        padding: EdgeInsets.zero,
                        itemBuilder: (context, index) {
                          return Padding(padding: const EdgeInsets.symmetric(horizontal: Dimensions.paddingSizeDefault),
                            child: SizedBox(width: ResponsiveHelper.isDesktop(context) ? 280 : Get.width * 0.2,
                              child: WhyChooseUsItemWidget(item: whyChooseUsModel.data?[index]),
                            ));
                        })
                        : const WhyChooseUsLoadingWidget(),
                  ): whyChooseUsModel != null ? ListView.builder(
                      itemCount: whyChooseUsModel.data?.length,
                      physics: const NeverScrollableScrollPhysics(),
                      shrinkWrap: true,
                      padding: EdgeInsets.zero,
                      itemBuilder: (context, index) {
                        return Padding(padding: const EdgeInsets.symmetric(horizontal: Dimensions.paddingSizeDefault),
                            child: SizedBox(width: ResponsiveHelper.isDesktop(context) ? 280 : Get.width * 0.2,
                              child: WhyChooseUsItemWidget(item: whyChooseUsModel.data?[index]),
                            ));
                      })
                      : const WhyChooseUsLoadingWidget()
                ],
              ),
            ),
          ),
        );
      },
    );
  }
}



class WhyChooseUsItemWidget extends StatelessWidget {
  final WhyChooseUsItem? item;
  const WhyChooseUsItemWidget({super.key, this.item});

  @override
  Widget build(BuildContext context) {
    return Column(children: [
      SvgPicture.asset(Images.logo),
      Column(crossAxisAlignment: CrossAxisAlignment.center, children: [
          CustomImage(image: "${AppConstants.imageBaseUrl}/why_choose_us/${item?.icon}", height: 150,),
          const SizedBox(height: Dimensions.paddingSizeDefault),
          Text("${item?.title}", style: textBold.copyWith(fontSize: 20, color: Theme.of(context).colorScheme.primary,),maxLines: 1, overflow: TextOverflow.ellipsis,),
          Text("${item?.description}",maxLines: ResponsiveHelper.isDesktop(context)? 3:2,overflow: TextOverflow.ellipsis,
            style: textRegular.copyWith(color: Theme.of(context).hintColor),textAlign: TextAlign.center,),

        ],
      ),
    ]);
  }
}
