
import 'package:flutter/material.dart';
import 'package:mighty_school/common/widget/custom_image.dart';
import 'package:mighty_school/util/styles.dart';

class ConvincedSlide extends StatelessWidget {
  const ConvincedSlide({
    super.key,
  });

  @override
  Widget build(BuildContext context) {
    return SizedBox(
      height: 436,
      child: Stack(
        alignment: Alignment.center,
        children: [
          const CustomImage(
            width: double.infinity,
            fit: BoxFit.cover,
          ),
          Center(
            child: Column(
              mainAxisSize: MainAxisSize.min,
              children: [
                // Main Title
                Text("Take the First Step Toward a Bright Future!",style: textBold.copyWith(
                    fontSize: 46,
                    color: Theme.of(context)
                        .scaffoldBackgroundColor)),
                const SizedBox(height: 10),

                // Subtitle
                Text(
                  "We’re excited to have you join our school community. Whether you’re ready to apply or just wan\nto ask questions, we’re here to help you through every step",
                  style: textRegular.copyWith(
                    fontSize: 20,
                    color: Colors.white70,
                  ),
                  textAlign: TextAlign.center,
                ),
                const SizedBox(height: 40),

                // Buttons
                InkWell(
                  onTap: () {},
                  child: Container(
                    decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(8),
                        color: Theme.of(context).primaryColor),
                    child: Padding(
                      padding: const EdgeInsets.symmetric(
                          horizontal: 30, vertical: 15),
                      child: Text(
                        "Apply Now",
                        style: textBold.copyWith(
                            color: Theme.of(context)
                                .scaffoldBackgroundColor),
                      ),
                    ),
                  ),
                ),
              ],
            ),
          )
        ],
      ),
    );
  }
}