import 'package:get/get_connect/http/src/response/response.dart';
import 'package:mighty_school/api_handle/api_client.dart';
import 'package:mighty_school/util/app_constants.dart';

class ExamResultRepository{
  final ApiClient apiClient;
  ExamResultRepository({required this.apiClient});

  Future<Response?> getExamResult(
      int classId,
      int? groupId,
      int? subjectId,
      int? studentId,
      int page,
      ) async {
    final queryParams = {
      'class_id': classId.toString(),
      if (groupId != null) 'group_id': groupId.toString(),
      if (subjectId != null) 'subject_id': subjectId.toString(),
      if (studentId != null) 'student_id': studentId.toString(),
      'page': page.toString(),
      'perPage': '10',
    };

    final uri = Uri(
      path: AppConstants.examResult,
      queryParameters: queryParams,
    );

    return await apiClient.getData(uri.toString());
  }

}