class ExamResultModel {
  bool? status;
  String? message;
  Data? data;
  ExamResultModel({this.status, this.message, this.data});
  ExamResultModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    message = json['message'];
    data = json['data'] != null ? Data.fromJson(json['data']) : null;

  }

}

class Data {
  int? currentPage;
  List<ResultItem>? data;
  int? total;

  Data({this.currentPage, this.data,  this.total});
  Data.fromJson(Map<String, dynamic> json) {
    currentPage = json['current_page'];
    if (json['data'] != null) {
      data = <ResultItem>[];
      json['data'].forEach((v) { data!.add(ResultItem.fromJson(v)); });
    }
    total = json['total'];
  }

}

class ResultItem {
  int? id;
  String? studentId;
  String? classId;
  String? groupId;
  String? subjectId;
  String? examId;
  String? mark1;
  String? mark2;
  String? mark3;
  String? mark4;
  String? mark5;
  String? mark6;
  String? totalMarks;
  String? gradePoint;
  String? grade;
  String? createdAt;
  String? updatedAt;
  Student? student;
  ClassInfo? classInfo;
  Group? group;
  Subject? subject;
  Exam? exam;

  ResultItem({this.id, this.studentId, this.classId, this.groupId, this.subjectId, this.examId, this.mark1, this.mark2, this.mark3, this.mark4, this.mark5, this.mark6, this.totalMarks, this.gradePoint, this.grade, this.createdAt, this.updatedAt, this.student, this.classInfo, this.group, this.subject, this.exam});

  ResultItem.fromJson(Map<String, dynamic> json) {
  id = json['id'];
  studentId = json['student_id'].toString();
  classId = json['class_id'].toString();
  groupId = json['group_id'].toString();
  subjectId = json['subject_id'].toString();
  examId = json['exam_id'].toString();
  mark1 = json['mark1'].toString();
  mark2 = json['mark2'].toString();
  mark3 = json['mark3'].toString();
  mark4 = json['mark4'].toString();
  mark5 = json['mark5'].toString();
  mark6 = json['mark6'].toString();
  totalMarks = json['total_marks'].toString();
  gradePoint = json['grade_point'].toString();
  grade = json['grade'].toString();
  createdAt = json['created_at'];
  updatedAt = json['updated_at'];
  student = json['student'] != null ? Student.fromJson(json['student']) : null;
  classInfo = json['class'] != null ? ClassInfo.fromJson(json['class']) : null;
  group = json['group'] != null ? Group.fromJson(json['group']) : null;
  subject = json['subject'] != null ? Subject.fromJson(json['subject']) : null;
  exam = json['exam'] != null ? Exam.fromJson(json['exam']) : null;
  }


}

class Student {
  int? id;
  String? group;
  String? firstName;
  String? lastName;
  StudentSession? studentSession;

  Student({this.id, this.group, this.firstName, this.lastName, this.studentSession});

  Student.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    group = json['group'];
    firstName = json['first_name'];
    lastName = json['last_name'];
    studentSession = json['student_session'] != null ? StudentSession.fromJson(json['student_session']) : null;
  }


  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['group'] = group;
    data['first_name'] = firstName;
    data['last_name'] = lastName;
    if (studentSession != null) {
      data['student_session'] = studentSession!.toJson();
    }
    return data;
  }


}

class StudentSession {
  int? id;
  String? classId;
  String? sectionId;
  String? roll;



  StudentSession({this.id, this.classId, this.sectionId, this.roll,});

  StudentSession.fromJson(Map<String, dynamic> json) {
  id = json['id'];
  classId = json['class_id'].toString();
  sectionId = json['section_id'].toString();
  roll = json['roll'];
  }


  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['class_id'] = classId;
    data['section_id'] = sectionId;
    data['roll'] = roll;
    return data;
  }


}

class ClassInfo {
  int? id;
  String? className;

  ClassInfo({this.id, this.className});

  ClassInfo.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    className = json['class_name'];
  }

}


class Group {
  int? id;
  String? groupName;

  Group({this.id, this.groupName});

  Group.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    groupName = json['group_name'];
  }

}

class Subject {
  int? id;
  String? subjectName;

  Subject({this.id, this.subjectName});

  Subject.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    subjectName = json['subject_name'];
  }

}

class Exam {
  int? id;
  String? name;

  Exam({this.id,  this.name});

  Exam.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

}


